/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import java.util.Map;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import xfacthd.framedblocks.api.model.FramedBlockModel;
import xfacthd.framedblocks.api.model.quad.Modifiers;
import xfacthd.framedblocks.api.model.quad.QuadModifier;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.client.model.FramedSlopePanelModel;
import xfacthd.framedblocks.client.model.FramedSlopeSlabModel;
import xfacthd.framedblocks.common.FBContent;

public class FramedPyramidModel
extends FramedBlockModel {
    private final Direction facing;

    public FramedPyramidModel(BlockState state, BakedModel baseModel) {
        super(state, baseModel);
        this.facing = (Direction)state.m_61143_((Property)BlockStateProperties.f_61372_);
    }

    @Override
    protected void transformQuad(Map<Direction, List<BakedQuad>> quadMap, BakedQuad quad) {
        Direction quadDir = quad.m_111306_();
        if (Utils.isY(this.facing)) {
            if (quadDir.m_122434_() == this.facing.m_122434_()) {
                return;
            }
            boolean up = this.facing == Direction.UP;
            QuadModifier.geometry(quad).apply(Modifiers.cutSideLeftRight(false, up ? 0.5f : 1.0f, up ? 1.0f : 0.5f)).apply(Modifiers.cutSideLeftRight(true, up ? 0.5f : 1.0f, up ? 1.0f : 0.5f)).apply(Modifiers.makeVerticalSlope(up, FramedSlopePanelModel.SLOPE_ANGLE)).export(quadMap.get(null));
        } else if (quadDir.m_122434_() == this.facing.m_122434_()) {
            QuadModifier.geometry(quad).apply(Modifiers.cutSideLeftRight(this.facing.m_122427_(), 1.0f, 0.5f)).apply(Modifiers.cutSideLeftRight(this.facing.m_122428_(), 1.0f, 0.5f)).apply(Modifiers.makeVerticalSlope(true, FramedSlopeSlabModel.SLOPE_ANGLE)).apply(Modifiers.offset(Direction.UP, 0.5f)).export(quadMap.get(null));
            QuadModifier.geometry(quad).apply(Modifiers.cutSideLeftRight(this.facing.m_122427_(), 0.5f, 1.0f)).apply(Modifiers.cutSideLeftRight(this.facing.m_122428_(), 0.5f, 1.0f)).apply(Modifiers.makeVerticalSlope(false, FramedSlopeSlabModel.SLOPE_ANGLE)).apply(Modifiers.offset(Direction.DOWN, 0.5f)).export(quadMap.get(null));
        } else if (!Utils.isY(quadDir)) {
            boolean right = quadDir == this.facing.m_122427_();
            QuadModifier.geometry(quad).apply(Modifiers.cutSideUpDown(true, right ? 1.0f : 0.5f, right ? 0.5f : 1.0f)).apply(Modifiers.cutSideUpDown(false, right ? 1.0f : 0.5f, right ? 0.5f : 1.0f)).apply(Modifiers.makeHorizontalSlope(!right, FramedSlopePanelModel.SLOPE_ANGLE)).export(quadMap.get(null));
        }
    }

    @Override
    protected void applyInHandTransformation(PoseStack poseStack, ItemTransforms.TransformType type) {
        poseStack.m_85837_(0.0, 0.5, 0.0);
    }

    public static BlockState itemSource() {
        return ((Block)FBContent.blockFramedPyramid.get()).m_49966_();
    }
}

